% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursSnowTemp.R
\name{getColoursSnowTemp}
\alias{getColoursSnowTemp}
\title{Gets colors for plotting snow temperature values}
\usage{
getColoursSnowTemp(Values, Resolution = 101, Verbose = F)
}
\arguments{
\item{Values}{Snowp temperature values}

\item{Resolution}{Resolution of color scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html color tuplets for debugging.}
}
\value{
Array with HTML color codes
}
\description{
Gets colors for plotting snow temperature values in snowprofiles. Colors are consistent with niViz at https://niviz.org
}
\examples{
require(SarpSnowGeneral)

SnowTemp <- c(-25:0)
plot(x = rep(1,length(SnowTemp)), y = SnowTemp, col = getColoursSnowTemp(SnowTemp), pch = 19,cex = 3)

}
