% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRecordsFromQuery.R
\name{getRecordsFromQuery}
\alias{getRecordsFromQuery}
\title{Gets record from snowpack analysis database based on SQL query}
\usage{
getRecordsFromQuery(DBName, Query, Verbose = F, SuppressDBWarnings = T,
  MaxNumTries = 10)
}
\arguments{
\item{DBName}{Name extension of database name}

\item{Query}{Properly formatted SQL query}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}

\item{MaxNumTries}{Number of times the function tries to connect to the database}
}
\value{
Dataframe with result
}
\description{
Gets record from snowpack analysis database based on SQL query
}
\examples{
require(SarpSnowGeneral)

DBName <- "test2018"
Query <- "Select * from executions"

Tbl_Exec <- getRecordsFromQuery(DBName = DBName, Query = Query)

}
