% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.studyArea.R
\name{plot.studyArea}
\alias{plot.studyArea}
\title{Plot map of study area}
\usage{
plot.studyArea(studyArea, nwpModel = "HRDPS", Google = FALSE,
  colCode = "band", minElevation = NULL, ...)
}
\arguments{
\item{studyArea}{the studyArea object (output of a calcStudyArea function)}

\item{nwpModel}{"HRDPS" (default) or "HRDPS_WEST"}

\item{colCode}{"band" (default) uses 3 colours for BTL/TL/ALP, "elevation" is 6 levels of colours based on elevation, "zone" is coloured by subregion}

\item{minElevation}{only show elevations above threshold}
}
\description{
Map with outline of study area and NWP grid points
}
\examples{
gnp <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/studyAreas/gnp.rds"))
par(mfrow = c(1,2))
plot(gnp)
plot(gnp, "HRDPS_WEST")
plot(gnp, Google = TRUE, cex = 3)

}
