% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyAreaBulletin.R
\name{studyAreaBulletin}
\alias{studyAreaBulletin}
\title{Determine study area for a bulletin region}
\usage{
studyAreaBulletin(name, regionName, hrdps = NULL, hrdpswest = NULL,
  elevationBands = TRUE, regionSeason = 2018)
}
\arguments{
\item{name}{name of the study area}

\item{regionName}{name of the bulletin region in the database}

\item{hrdps}{DEM of HRDPS model}

\item{hrdpswest}{DEM of HRDPS_WEST model}

\item{elevationBands}{DEM contains preset treeline elevations for each gridpoint}

\item{regionSeason}{season of the region in the database (default 2018)}
}
\value{
studyArea object
}
\description{
Determine study area for a bulletin region
}
\examples{
library(SarpBulletinTools)
library(SarpBulletinToolsPrivate)
hrdps <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_DEM.rds"))
hrdpswest <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_WEST_DEM.rds"))
gnp <- studyAreaBulletin("GNP", "Glacier", hrdps, hrdpswest)

}
