% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyAreaGps.R
\name{studyAreaGps}
\alias{studyAreaGps}
\title{Determine study area for an InfoEx operation with GPS tracking data}
\usage{
studyAreaGps(name, operationCode, hrdps = NULL, hrdpswest = NULL,
  elevationBands = TRUE)
}
\arguments{
\item{name}{name of the study area}

\item{operationCode}{name of the operation in the database}

\item{hrdps}{DEM of HRDPS model}

\item{hrdpswest}{DEM of HRDPS_WEST model}

\item{elevationBands}{DEM contains preset treeline elevations for each gridpoint}
}
\value{
studyArea object
}
\description{
Determine study area for an InfoEx operation with GPS tracking data
}
\examples{
library(SarpGPSTools)
library(SarpGPSToolsPrivate)
hrdps <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_DEM.rds"))
hrdpswest <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_WEST_DEM.rds"))
whs <- studyAreaGps("WHS", "WHS", hrdps, hrdpswest)

}
