% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyAreaKml.R
\name{studyAreaKml}
\alias{studyAreaKml}
\title{Determine study area from kml polygons}
\usage{
studyAreaKml(name, kmlFile, kmlRegionName, hrdps = NULL,
  hrdpswest = NULL, elevationBands = TRUE)
}
\arguments{
\item{name}{name of the study area}

\item{kmlFile}{path to kml file containing polygons}

\item{kmlRegionName}{the name of the feature in the kml file}

\item{hrdps}{DEM of HRDPS model}

\item{hrdpswest}{DEM of HRDPS_WEST model}

\item{elevationBands}{DEM contains preset treeline elevations for each gridpoint}
}
\value{
studyArea object
}
\description{
Determine study area from kml polygons
}
\examples{
hrdps <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_DEM.rds"))
hrdpswest <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_WEST_DEM.rds"))
heli <- studyAreaKml("heli", kmlFile = 'kml/Helicat.kml', kmlRegionName = 'Helicat', hrdps, hrdpswest)
}
